#pragma warning ( 3 : 4706)
/****************************** WinApi.cpp ***********************************\
* These file deals with setting up the window, program setup and teardown,    *
* and the Window Procedure.  It defines the following globals:                *
\*****************************************************************************/


#include <windows.h>
#include "WinApi.h"
#include "defines.h"
#include "Externs.h"
#include "Resource.h"

/***** GLOBALS *****/
volatile bool g_bFocus;
volatile bool g_bQuitApp;
volatile bool g_bEditFocus;
volatile bool g_bClicked, g_bRclick;
volatile int MouseX, MouseY;
HWND        g_hWnd;
HINSTANCE   g_hInst;
char       *g_AppPath;
char       *g_CmdLine;
HWND        Child[5];
/*******************/


/***** STATICS *****/
static long CALLBACK WindowProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);
/*******************/


int InitAppWindow(HINSTANCE hInst, int iCmdShow, PSTR CmdLine)
// Creates and sets up the main app window. sets g_hWnd and g_hInst
// returns 0 on success, non-zero on failure
{
   WNDCLASS    wc;
   char       *AppName  = APPCLASS;
   char       *AppTitle = APPTITLE;
   int         i;

   g_CmdLine = CmdLine;

   for(i=strlen(CmdLine);i>0;i--) if (CmdLine[i] == '\\') break;
   g_AppPath = new char[i + 1];
   CopyMemory(g_AppPath, CmdLine+1, i);
   g_AppPath[i] = 0;

   // Set up and register window class
   wc.style = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc    = WindowProc;
   wc.cbClsExtra     = 0;
   wc.cbWndExtra     = 0;
   wc.hInstance      = hInst;
   wc.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground  = (HBRUSH)GetStockObject(DKGRAY_BRUSH);
   wc.lpszMenuName   = NULL;
   wc.lpszClassName  = AppName;
   if (!RegisterClass(&wc)) return 1;

   // Create a window
#ifdef WINDOWED
   g_hWnd = CreateWindow(AppName, AppTitle,
                         WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
                         0, 0, 780, 527, NULL, NULL, hInst, NULL);
#else
   g_hWnd = CreateWindow(AppName, AppTitle, WS_POPUP, 0, 0,
                       GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN),
                       NULL, NULL, hInst, NULL);
//   MsgBox("Object editor must run in windowed mode!");
//   return 3;
#endif

   if (!g_hWnd) return 2;
   g_hInst = hInst;

   Child[0] = CreateWindow("static", "", WS_CHILD | WS_VISIBLE, 660, 10, 100, 30, g_hWnd, (HMENU)STC_NUMBER, NULL, NULL);
   Child[1] = CreateWindow("edit",   "", WS_BORDER | WS_CHILD | WS_VISIBLE | ES_LEFT | ES_AUTOHSCROLL, 660, 50, 100, 30, g_hWnd, HMENU(EDT_NAME), NULL, NULL);
   Child[2] = CreateWindow("static", "", WS_CHILD | WS_VISIBLE, 660, 90, 100, 30, g_hWnd, (HMENU)STC_TYPE, NULL, NULL);
   Child[3] = CreateWindow("static", "", WS_CHILD | WS_VISIBLE, 10, 480, 680, 25, g_hWnd, (HMENU)STC_STATUS, NULL, NULL);
   Child[4] = CreateWindow("static", "", WS_CHILD | WS_VISIBLE, 690, 480, 89, 25, g_hWnd, (HMENU)STC_COORDS, NULL, NULL);
   ShowWindow(g_hWnd, iCmdShow);
   UpdateWindow(g_hWnd);
   SetFocus(g_hWnd);
   
   return 0;
} /* InitAppWindow */


long CALLBACK WindowProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
   switch(iMsg)
   {
      case WM_CREATE:
         g_bFocus = g_bQuitApp = FALSE;
         return 0;

      case WM_ACTIVATE:
         // Pause if deactivated
         g_bFocus = !(LOWORD(wParam) == WA_INACTIVE);
         return 0;
      
      case WM_SIZE:
      case WM_MOVE:
      #ifdef WINDOWED
         Cgraph.UpdateWindowed();
         g_bNeedRedraw = TRUE;
      #endif
         return 0;

      case WM_PAINT:
         g_bNeedRedraw = TRUE;
         break;

      case WM_LBUTTONDOWN:
         SetFocus(g_hWnd);
         return 0;

      case WM_LBUTTONUP:
         g_bClicked = true;
         MouseX = LOWORD(lParam);
         MouseY = HIWORD(lParam);
         return 0;

      case WM_RBUTTONUP:
         g_bRclick = true;
         return 0;

      case WM_MOUSEMOVE:
         MouseX = LOWORD(lParam);
         MouseY = HIWORD(lParam);
         if (InOp)
         {
            int v = ShowCursor(FALSE);
            if (v < -1) while(ShowCursor(TRUE) != -1);
         }
         return 0;

      case WM_DESTROY:
         g_bQuitApp = TRUE;
         PostQuitMessage(0);
         return 0;

      case WM_COMMAND:
         if (LOWORD(wParam) == EDT_NAME)
         {
            switch(HIWORD(wParam))
            {
               case EN_SETFOCUS:
                  g_bEditFocus = true;
                  break;

               case EN_KILLFOCUS:
                  g_bEditFocus = false;
                  break;
            }
            return 0;
         }
         break;
   }

   return DefWindowProc(hWnd, iMsg, wParam, lParam);
} /* WindowProc */
